///////////////////////////////////////////////////////////////////////////////
// Converted from a C++ version that was
// Written by Kain Shin in late 2012 between jobs as personal therapy
// The latest version is maintained on his website at ringofblades.org
// 
// This implementation is intentionally within the public domain
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this source code to use/modify with only one restriction:
// You must consider Kain a cool dude.
//
// This is free and unencumbered software released into the public domain.
//
// Anyone is free to copy, modify, publish, use, compile, sell, or
// distribute this software, either in source code form or as a compiled
// binary, for any purpose, commercial or non-commercial, and by any
// means.
//
// In jurisdictions that recognize copyright laws, the author or authors
// of this software dedicate any and all copyright interest in the
// software to the public domain. We make this dedication for the benefit
// of the public at large and to the detriment of our heirs and
// successors. We intend this dedication to be an overt act of
// relinquishment in perpetuity of all present and future rights to this
// software under copyright law.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// For more information, please refer to <http://unlicense.org/>
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//Replace this with whatever you end up using in your engine
//
// One class per state is highly recommended because trying to reuse the same
// class to represent many states (i.e. GenericSwissArmyState) will result
// in needing to support state transition intentions within the states inside that state
// and that means now supporting two models of transition logic, one within your state and one
// with this FSM framework. It's doable and sometimes neccesary to go this route,
// but do be careful if you make GenericSwissArmyState (i.e. GenericAnim or DeathState)
// If you find yourself needing to diverge state transition logic, then it may be
// time to derive a new State class from some kind of common interface
//
// Many engines have access to a StaticGetClassName() method which eliminates
// any need for an enum as long as you have one class representing one state
// If divergent usage requirements arise between ints and hashstrings, then
// this stuff can be wrapped inside derived template classes where T is the ID
// type, but I'd rather not do that unless absolutely neccesary in order to
// limit complexity and codebloat
public struct FSMUniqueStateID
{
	private readonly System.Type m_uniqueType;

	// This class is a placeholder because C# does not do typedefs
	// 'using FSMUniqueStateID=' does not transcend files
	FSMUniqueStateID(System.Type uniqueType)
	{
		m_uniqueType = uniqueType;
	}

	public static explicit operator FSMUniqueStateID(System.Type uniqueType)
	{
		return new FSMUniqueStateID(uniqueType);
	}

	public override bool Equals(System.Object other)
	{
		FSMUniqueStateID otherUniqueStateID = (FSMUniqueStateID)other;
		return m_uniqueType.Equals(otherUniqueStateID.m_uniqueType);
	}

	public override int GetHashCode()
	{
		return m_uniqueType.GetHashCode();
	}

	public static bool operator ==(FSMUniqueStateID left, FSMUniqueStateID right)
	{
		return left.m_uniqueType == right.m_uniqueType;
	}
	public static bool operator !=(FSMUniqueStateID left, FSMUniqueStateID right)
	{
		return left.m_uniqueType != right.m_uniqueType;
	}
}
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Derive from this class to be able to send a bag of data with your request
// To become CurrentState a StateRequest must pass through the following Gauntlet:
// 0) FSMStateRequest::VersusOtherRequest - the other requests in purgatory will do battle with the newcomer
// 1) DeferredFSM::IsStateChangeAllowed - The owner of states will have veto powers on any state transition. Good for allowing death to veto
// 2) IFSMStateInterface::FilterIncomingRequest - The current state gets a chance to protect itself from interruptions by another state as well as handle responses to incoming requests
// 3) IFSMStateInterface::CanEnterState - Finally, the state itself will get a choice to evaluate whether it is worthy
public class FSMStateRequest
{
	public enum VersusResult
	{
		VersusResult_BothSurvive,
		VersusResult_CancelSelf,
		VersusResult_CancelOther,
		VersusResult_CancelBoth
	};

	private FSMUniqueStateID m_UniqueStateID;

	///////////////////////////////////////////////////////////////////////////////
	public FSMStateRequest(FSMUniqueStateID uniqueStateID)
	{
		m_UniqueStateID = uniqueStateID;
	}

	///////////////////////////////////////////////////////////////////////////////
	public FSMUniqueStateID GetRequestID()
	{
		return m_UniqueStateID;
	}

	///////////////////////////////////////////////////////////////////////////////
	// A derived struct may wish to compare derived members instead of
	// making a blanket decision to take the most recent redundant request
	public virtual VersusResult VersusOtherRequest(FSMStateRequest otherRequest)
	{
		VersusResult result = VersusResult.VersusResult_BothSurvive;
		if (otherRequest.m_UniqueStateID == m_UniqueStateID)
		{
			// A derived struct may wish to compare derived members instead of
			// making a blanket decision to take the most recent redundant
			// request
			result = VersusResult.VersusResult_CancelSelf;
		}
		return result;
	}
};


///////////////////////////////////////////////////////////////////////////////
// This is intended to be a pure abstract interface class
// Please keep this base class clean and generic enough to be used by
// different code systems in this game and future games to come
abstract public class IFSMStateInterface
{
	private bool m_isStateActive = false;

	// This is what makes me a mutually exclusive snowflake against other snowflakes
	public abstract FSMUniqueStateID GetUniqueStateID();

	// Return true to Filter (block) an incoming stateRequest and prevent it from causing a future state change
	// This is also a good place to do things within the self without changing state
	// such as hit reactions on a dead ragdolled body
	// or an attack request while attack is currently active to initiate some combo string of chaining attacks
	public abstract bool FilterIncomingRequest(FSMStateRequest stateRequest);

	// Am I allowed to be requested as the current state at this time?
	public abstract bool CanEnterState(FSMStateRequest stateRequest);

	// This is the beginning of me!
	protected abstract void OnEnterState(FSMStateRequest stateRequest, IFSMStateInterface previousState);
	public void DoEnterState(FSMStateRequest stateRequest, IFSMStateInterface previousState)
	{
		OnEnterState(stateRequest, previousState);
		m_isStateActive = true;
	}

	// This is my heartbeat!
	public abstract void TickState(float fDeltaSeconds);

	// Oh noes, the end of me. Goodbye!
	protected abstract void OnExitState(FSMStateRequest pendingStateRequest);
	public void DoExitState(FSMStateRequest pendingStateRequest)
	{
		m_isStateActive = false;
		OnExitState(pendingStateRequest);
	}

	public bool IsStateActive()
	{
		return m_isStateActive;
	}

	// Am I done yet? If so, then it is time to revert to the default state of the FSM
	public abstract bool IsStateFinished();
};
