// This code was created by Jeff Molofee '99
// (ported to SDL by Sam Lantinga '2000)
// Then Kain Shin came along and used it as the base for an SDL-based engine
// ... making some drastic changes along the way

#include "StdAfx.h"
#include "SDL_ttf.h"
#include "AudioManager.h" //a wrapper class provided for your convenience



#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 480



int main(int argc, char *argv[]) 
{
	//Initialize SDL
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 )
	{
		fprintf(stderr, "Unable to initialize SDL: %s\n", SDL_GetError());
	}

	//Initialize SDL_ttf and if it fails, report the error.
	if ( -1==TTF_Init() )
	{
		fprintf(stderr, "Unable to initialize SDL_ttf: %s", TTF_GetError());
	}

	//Set the video mode and initialize the main backbuffer
	SDL_Surface* pScreenBuffer = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, 16, SDL_DOUBLEBUF);
	if ( pScreenBuffer == NULL )
	{
		fprintf(stderr, "Unable to create OpenGL pScreenBuffer: %s\n", SDL_GetError());
		TTF_Quit();
		SDL_Quit();
	}

	//Set the window caption
	SDL_WM_SetCaption("GAME 1024 Class Project", NULL);

	//Initialize the sprite...
	SDL_Surface* pSprite = SDL_LoadBMP("Art\\pokemans.bmp");
	assert(NULL!=pSprite && "you might have a pathing issue.  Did you set your 'Working Directory' to '$(OutDir)' in your GameEXE vcproj properties?");
	if( -1==SDL_SetColorKey(pSprite, SDL_SRCCOLORKEY | SDL_RLEACCEL, SDL_MapRGB(pSprite->format, 255, 0, 255)) )
	{
		fprintf(stderr, "Warning: Colorkey will not be used, reason: %s\n", SDL_GetError());
	}

	//Initialize the text...
	char buffer[MAX_PATH];
	TTF_Font* font = TTF_OpenFont("Fonts\\arial.ttf", 14);
	if(font == NULL)
	{
		assert(false && "you might have a pathing issue.  Did you set your 'Working Directory' to '$(OutDir)' in your GameEXE vcproj properties?");
		fprintf(stderr, "TTF_OpenFont: %s", TTF_GetError());
	}
	sprintf_s(buffer, "Press \"Esc\" to exit");
	SDL_Color fontColor;
	fontColor.r = 0;
	fontColor.g = 142;
	fontColor.b = 0;
	SDL_Surface* pText = TTF_RenderText_Solid(font, buffer, fontColor);

	//Hey Student, you should eventually make this audioWrapper a member of a singleton game class
	cAudioManager audioManager;
	cSoundBuffer* pDootSound = audioManager.CreateSoundBuffer("Sound\\doot.wav");

	bool done = false;
	while ( !done )
	{
		SDL_Rect src, dst;

		//Clear the screen to white
		dst.x = 0;
		dst.y = 0;
		dst.w = SCREEN_WIDTH;
		dst.h = SCREEN_HEIGHT;
		SDL_FillRect(pScreenBuffer, &dst, 0xFFFFFFFF);

		//Draw a sprite...
		src.x = 0;
		src.y = 0;
		src.w = SCREEN_WIDTH;
		src.h = SCREEN_HEIGHT;
		dst.x = 10;
		dst.y = 10;
		dst.w = SCREEN_WIDTH;
		dst.h = SCREEN_HEIGHT;
		Uint8 alpha = 200;
		if (alpha != 255)
		{
			SDL_SetAlpha(pSprite, SDL_SRCALPHA, alpha);
		}
		SDL_BlitSurface(pSprite, &src, pScreenBuffer, &dst);

		//Draw some text...
		src.x = 0;
		src.y = 0;
		src.w = SCREEN_WIDTH;
		src.h = SCREEN_HEIGHT;
		dst.x = 300;
		dst.y = 400;
		dst.w = SCREEN_WIDTH;
		dst.h = SCREEN_HEIGHT;
		alpha = 200;
		if (alpha != 255)
		{
			SDL_SetAlpha(pText, SDL_SRCALPHA, alpha);
		}
		SDL_BlitSurface(pText, &src, pScreenBuffer, &dst);

		//Flip the screen buffer
		SDL_Flip(pScreenBuffer);

		/* This could go in a separate function */
		SDL_Event event;
		while ( SDL_PollEvent(&event) )
		{
			//Hey student, Check out some of the other enums in sdl_events.h
			if ( event.type == SDL_QUIT )
			{
				done = true;
			}
			if ( event.type == SDL_KEYDOWN )
			{
				switch (event.key.keysym.sym)
				{
				case VK_ESCAPE:	//'esc' key
					done = true;
				default:
					pDootSound->Play();
				}//end switch
			}
		}

		//sleep for 3 ms to avoid hogging CPU cycles
		SDL_Delay(3);
	}

	//Shutdown...
	TTF_Quit();
	SDL_Quit();

	return 1;
}
